import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Link from 'components/Link/Link';

export interface ITrainsBreadcrumbsItemProps
    extends IWithClassName,
        IWithQaAttributes {
    to?: string;
    title?: string;
    onClick?: React.MouseEventHandler;
}

const TrainsBreadcrumbsItem: React.FC<ITrainsBreadcrumbsItemProps> = props => {
    const {className, to, title, onClick, children} = props;

    if (to) {
        return (
            <Link
                className={className}
                theme="normal"
                to={to}
                title={title}
                onClick={onClick}
                {...prepareQaAttributes(props)}
            >
                {children}
            </Link>
        );
    }

    return (
        <span
            className={className}
            title={title}
            onClick={onClick}
            {...prepareQaAttributes(props)}
        >
            {children}
        </span>
    );
};

export default TrainsBreadcrumbsItem;
