import React, {Fragment} from 'react';

import {CHAR_NBSP} from 'utilities/strings/charCodes';

import {ITrainsBreadcrumbsProps} from 'projects/trains/components/TrainsBreadcrumbs';
import {ITrainsBreadcrumbsItemProps} from 'projects/trains/components/TrainsBreadcrumbs/TrainsBreadcrumbsItem';
import ArrowIcon from 'icons/16/Arrow';

import cx from './styles.scss';

const TrainsBreadcrumbsMobile: React.FC<ITrainsBreadcrumbsProps> = props => {
    const {className, children} = props;
    const count = React.Children.count(children);

    return (
        <ol className={cx('root', className)}>
            {React.Children.map(
                children,
                (
                    child: React.ReactElement<ITrainsBreadcrumbsItemProps>,
                    index: number,
                ) => {
                    const isFirst = index === 0;
                    const isLast = index === count - 1;

                    return (
                        <li
                            className={cx('listItem', {
                                listItem_first: isFirst,
                                listItem_last: isLast,
                            })}
                        >
                            {React.cloneElement(child, child.props)}

                            {!isLast && (
                                <Fragment>
                                    {CHAR_NBSP}

                                    <ArrowIcon className={cx('arrow')} />
                                </Fragment>
                            )}
                        </li>
                    );
                },
            )}
        </ol>
    );
};

export default TrainsBreadcrumbsMobile;
