import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import TrainsBreadcrumbsItem, {
    ITrainsBreadcrumbsItemProps,
} from 'projects/trains/components/TrainsBreadcrumbs/TrainsBreadcrumbsItem';
import TrainsBreadcrumbsDesktop from 'projects/trains/components/TrainsBreadcrumbs/TrainsBreadcrumbsDesktop';
import TrainsBreadcrumbsMobile from 'projects/trains/components/TrainsBreadcrumbs/TrainsBreadcrumbsMobile';

export interface ITrainsBreadcrumbsProps extends IWithClassName {
    children: React.ReactElement<ITrainsBreadcrumbsItemProps>[];
}

interface ITrainsBreadcrumbsItem {
    Item: React.FC<ITrainsBreadcrumbsItemProps>;
}

const TrainsBreadcrumbs: React.FC<ITrainsBreadcrumbsProps> &
    ITrainsBreadcrumbsItem = props => {
    const deviceType = useDeviceType();

    const TrainsBreadcrumbsComponent = deviceType.isMobile
        ? TrainsBreadcrumbsMobile
        : TrainsBreadcrumbsDesktop;

    return <TrainsBreadcrumbsComponent {...props} />;
};

TrainsBreadcrumbs.Item = TrainsBreadcrumbsItem;

export default TrainsBreadcrumbs;
