import React, {ReactNode} from 'react';

import {IGenericOrderInfo} from 'server/api/GenericOrderApi/types/common/IGenericOrderInfo';
import {ITrainsTariffCategory} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';

import {trainsURLs} from 'projects/trains/lib/urls';
import {getFirstTrainService} from 'projects/trains/lib/complexOrder/getFirstTrainService';

import Link from 'components/Link/Link';

export interface ITrainsFeedbackLinkProps {
    children: ReactNode;
    orderInfo: IGenericOrderInfo;
    tariffCategories?: ITrainsTariffCategory[];
}

const TrainsFeedbackLink: React.FC<ITrainsFeedbackLinkProps> = ({
    orderInfo,
    tariffCategories,
    children,
}) => {
    const trainService = getFirstTrainService(orderInfo);

    return (
        <Link
            theme="normal"
            target="_blank"
            url={trainsURLs.getOrderFeedbackUrl(
                {
                    uid: orderInfo.id,
                    passengers: trainService?.trainInfo.passengers,
                },
                tariffCategories,
            )}
        >
            {children}
        </Link>
    );
};

export default TrainsFeedbackLink;
