import React from 'react';
import {RouteComponentProps} from 'react-router-dom';

import {ORDER_STEP} from 'projects/trains/constants/orderSteps';

import TrainsOrderPlacesStep from 'projects/trains/components/TrainsOrderPage/PlacesStep/PlacesStep';
import TrainsOrderPassengersStep from 'projects/trains/components/TrainsOrderPage/PassengersStep/TrainsOrderPassengersStep';
import ConfirmStepContainer from 'projects/trains/components/TrainsOrderPage/ConfirmStep/ConfirmStepContainer';
import PaymentPage from 'projects/trains/components/PaymentPage/PaymentPage';

function getComponentByOrderStep(
    orderStep: ORDER_STEP,
): React.ElementType | undefined {
    switch (orderStep) {
        case ORDER_STEP.PLACES: {
            return TrainsOrderPlacesStep;
        }

        case ORDER_STEP.PASSENGERS: {
            return TrainsOrderPassengersStep;
        }

        case ORDER_STEP.CONFIRM: {
            return ConfirmStepContainer;
        }

        case ORDER_STEP.PAYMENT: {
            return PaymentPage;
        }
    }
}

/*
 * При переходе с помощью браузерных кнопок назад/вперед компоненты, соответствующие новым роутам (Route)
 * рендерятся в первую очередь. В результате получается, например, при переходе с шага ввода данных пассажиров
 * на шаг выбора мест с помощью браузерного "назад", компонент выбора мест отрендерится с orderStep === 'passengers'.
 * Чтобы предотвращать подобное, нужно делать проверку на актуальность текущего шага покупки.
 */
export default function renderOrderStep(
    orderStep: ORDER_STEP,
    orderStepForRender: ORDER_STEP,
) {
    return function RenderOrderStep(
        routeProps: RouteComponentProps,
    ): React.ReactNode {
        if (orderStep !== orderStepForRender) {
            return null;
        }

        const OrderStepComponent = getComponentByOrderStep(orderStepForRender);

        if (!OrderStepComponent) {
            return null;
        }

        return <OrderStepComponent {...routeProps} />;
    };
}
