import {createSelector} from 'reselect';
import {Action} from 'redux';

import {ORDER_STEP} from 'projects/trains/constants/orderSteps';

import {TOrderStepDescription} from 'reducers/trains/order/thunk/changeOrderStep';

import stepRestrictionsDataSelector from 'selectors/trains/order/stepRestrictionsDataSelector';
import {orderStepSelector} from 'selectors/trains/order/orderStepSelector';
import nextOrderStepSelector from 'selectors/trains/order/nextOrderStepSelector';

import {getSolutions} from 'projects/trains/lib/order/stepRestrictions/solutions';
import {
    getRestrictions,
    IStepRestriction,
} from 'projects/trains/lib/order/stepRestrictions/restrictions';

interface IOrderButtonSelector {
    disabled: boolean;
    solutions: (() => Action)[];
    restrictions: IStepRestriction[];
    orderStep: ORDER_STEP;
    nextOrderStep: TOrderStepDescription;
}

export default createSelector(
    [stepRestrictionsDataSelector, orderStepSelector, nextOrderStepSelector],
    (stepRestrictionsData, orderStep, nextOrderStep): IOrderButtonSelector => {
        const restrictions = getRestrictions(orderStep)(stepRestrictionsData);
        const solutions = getSolutions(restrictions, stepRestrictionsData);
        const disabled = Boolean(restrictions.length);

        return {
            disabled,
            solutions,
            restrictions,
            orderStep,
            nextOrderStep,
        };
    },
);
