import {CustomThunkAction} from 'reducers/trains/customDispatch';

import currentTrainStateSelector from 'selectors/trains/order/currentTrainStateSelector';
import passengersCountSelector from 'selectors/trains/order/passengersCountSelector';

import reachGoalUserRequirements from 'projects/trains/lib/order/metrika/reachGoalUserRequirements';
import {params} from 'utilities/metrika';

export default function sendOnValidClickInPlacesMetrika(): CustomThunkAction<
    Promise<void>
> {
    return async (dispatch, getState): Promise<void> => {
        const state = getState();

        const train = currentTrainStateSelector(state);
        const passengers = passengersCountSelector(state);

        if (!train) {
            return;
        }

        reachGoalUserRequirements(train, passengers);

        const initialExpandedServiceClass = train?.initialExpandedServiceClass;
        const expandedServiceClass = train?.expandedServiceClass;

        const serviceClassChanged =
            initialExpandedServiceClass !== expandedServiceClass;

        if (initialExpandedServiceClass !== null) {
            params({
                trains: {
                    service_class_changed: serviceClassChanged,
                },
            });
        }
    };
}
