import {ORDER_STEP} from 'projects/trains/constants/orderSteps';

import {TOrderStepDescription} from 'reducers/trains/order/thunk/changeOrderStep';

import * as i18nBlock from 'i18n/trains-order-steps';

/**
 * Текст кнопки основного действия на шагах оплаты
 */
export default function getActionButtonText(
    nextStep: TOrderStepDescription,
): string {
    switch (nextStep.step) {
        case ORDER_STEP.PLACES:
            return i18nBlock.stepNext();

        case ORDER_STEP.PASSENGERS:
            return i18nBlock.stepDashPlacesDashActionDashButton();

        case ORDER_STEP.CONFIRM:
            return i18nBlock.stepDashPassengersDashActionDashButton();

        case ORDER_STEP.PAYMENT:
            return i18nBlock.stepDashConfirmDashActionDashButton();
    }
}
