import React, {useCallback} from 'react';
import {useDispatch} from 'react-redux';

import {IWithClassName} from 'types/withClassName';

import changeOrderStep from 'reducers/trains/order/thunk/changeOrderStep';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {FIRST_PLACES_STEP} from 'projects/trains/lib/order/steps/firstPlacesStep';

import * as i18nBlock from 'i18n/trains-order-confirm';

import LinkButton from 'components/LinkButton/LinkButton';

interface ICancelOrderButtonProps extends IWithClassName, IWithQaAttributes {}

const CancelOrderButton: React.FC<ICancelOrderButtonProps> = props => {
    const {className} = props;
    const dispatch = useDispatch();

    const handleClick = useCallback(() => {
        dispatch(changeOrderStep(FIRST_PLACES_STEP));
    }, [dispatch]);

    return (
        <span className={className}>
            <LinkButton
                onClick={handleClick}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'cancelButton',
                })}
            >
                {i18nBlock.cancelOrderButtonText()}
            </LinkButton>
            , {i18nBlock.cancelOrderButtonReason()}
        </span>
    );
};

export default CancelOrderButton;
