import React from 'react';

import {ECoachAbility} from 'types/trains/booking/ECoachAbility';
import {ECoachFacility} from 'types/trains/booking/ECoachFacility';

import getFacilityAndAbilityIcon from './utilities/getFacilityAndAbilityIcon';
import {getPreparedFacilityAndAbilityHint} from './utilities/getFacilityAndAbilityHint';
import getFacilityAndAbilityIconClassName from 'projects/trains/components/TrainsOrderPage/Coach/components/CoachAdditionalInfo/components/CoachFacilitiesAndAbilities/utilities/getFacilityAndAbilityIconClassName';

import TextWithIcon, {TSize} from 'components/TextWithIcon/TextWithIcon';

interface ICoachFacilitiesAndAbilitiesProps {
    itemSize: TSize;
    itemClassName?: string;
    facilitiesAndAbilities: (ECoachFacility | ECoachAbility)[];
}

const CoachFacilitiesAndAbilities: React.FC<ICoachFacilitiesAndAbilitiesProps> =
    props => {
        const {facilitiesAndAbilities, itemSize, itemClassName} = props;

        return (
            <>
                {facilitiesAndAbilities.map((item, index) => (
                    <TextWithIcon
                        key={index}
                        size={itemSize}
                        className={itemClassName}
                        text={getPreparedFacilityAndAbilityHint(item)}
                        iconLeft={getFacilityAndAbilityIcon(item)}
                        iconLeftClassName={getFacilityAndAbilityIconClassName(
                            item,
                        )}
                    />
                ))}
            </>
        );
    };

export default CoachFacilitiesAndAbilities;
