import React from 'react';

import {ECoachAbility} from 'types/trains/booking/ECoachAbility';
import {ECoachFacility} from 'types/trains/booking/ECoachFacility';

import * as i18n from 'i18n/trains-coach-facilities';

import Link from 'components/Link/Link';

export function getReplacedFacilityType(
    abilityOrFacility: ECoachAbility | ECoachFacility,
): ECoachAbility | ECoachFacility {
    return abilityOrFacility ===
        ECoachAbility.ANIMALS_NEED_TO_BUY_TICKET_OFFLINE
        ? ECoachAbility.ANIMALS
        : abilityOrFacility;
}

export function getRawFacilityAndAbilityHint(
    abilityOrFacility: ECoachAbility | ECoachFacility,
): string | null {
    switch (abilityOrFacility) {
        case ECoachFacility.EAT:
            return i18n.eat();
        case ECoachFacility.PAP:
            return i18n.pap();
        case ECoachFacility.TV:
            return i18n.tv();
        case ECoachFacility.TRAN:
            return i18n.tran();
        case ECoachFacility.COND:
            return i18n.cond();
        case ECoachFacility.BED:
            return i18n.bed();
        case ECoachFacility.SAN:
            return i18n.san();
        case ECoachFacility.WIFI:
            return i18n.wifi();
        case ECoachFacility.WC:
            return i18n.wc();

        case ECoachAbility.NO_ELECTRONIC_REGISTRATION:
            return i18n.noDashEreg();

        case ECoachAbility.ANIMALS:
        case ECoachAbility.ANIMALS_NEED_TO_BUY_TICKET_OFFLINE: {
            return i18n.animalsDashTitleDashShort();
        }
        case ECoachAbility.GENDER_MALE:
        case ECoachAbility.GENDER_FEMALE:
        case ECoachAbility.GENDER_MIXED:
        case ECoachAbility.GENDER_SINGLE:
            return null;
    }
}

export function getPreparedFacilityAndAbilityHint(
    abilityOrFacility: ECoachAbility | ECoachFacility,
): React.ReactNode | null {
    if (abilityOrFacility === ECoachAbility.NO_ELECTRONIC_REGISTRATION) {
        return (
            <Link
                theme="brand"
                text={i18n.noDashEregDashHintDashText()}
                url={i18n.noDashEregDashUrl()}
                target="_blank"
                rel="noopener noreferrer"
            />
        );
    }

    return getRawFacilityAndAbilityHint(abilityOrFacility);
}
