import {FC} from 'react';

import {ECoachAbility} from 'types/trains/booking/ECoachAbility';
import {ECoachFacility} from 'types/trains/booking/ECoachFacility';
import {IIconProps} from 'icons/types/icon';

import AnimalsIcon from 'icons/16/Animals';
import AirConditionerIcon from 'icons/16/AirConditioner';
import FoodIcon from 'icons/16/Food';
import NoOnlineRegistrationIcon from 'icons/16/NoOnlineRegistration';
import ToiletIcon from 'icons/16/Toilet';
import WiFiIcon from 'icons/16/WiFi';
import EmptyComponent from 'components/EmptyComponent/EmptyComponent';

export default function getFacilityAndAbilityIcon(
    abilityOrFacility: ECoachAbility | ECoachFacility,
): FC<IIconProps> {
    switch (abilityOrFacility) {
        case ECoachAbility.ANIMALS:
            return AnimalsIcon;
        case ECoachFacility.COND:
            return AirConditionerIcon;
        case ECoachFacility.EAT:
            return FoodIcon;
        case ECoachAbility.NO_ELECTRONIC_REGISTRATION:
            return NoOnlineRegistrationIcon;
        case ECoachFacility.WC:
            return ToiletIcon;
        case ECoachFacility.WIFI:
            return WiFiIcon;
        default:
            return EmptyComponent;
    }
}
