import {ECoachAbility} from 'types/trains/booking/ECoachAbility';
import {ECoachFacility} from 'types/trains/booking/ECoachFacility';

import * as i18n from 'i18n/trains-coach-facilities';

export default function getFacilityAndAbilityTitle(
    abilityOrFacility: ECoachAbility | ECoachFacility,
    short: boolean,
): string | null {
    switch (abilityOrFacility) {
        case ECoachFacility.EAT:
        case ECoachFacility.PAP:
        case ECoachFacility.TV:
        case ECoachFacility.TRAN:
        case ECoachFacility.COND:
        case ECoachFacility.BED:
        case ECoachFacility.SAN:
        case ECoachFacility.WIFI:
        case ECoachFacility.WC:
            return null;

        case ECoachAbility.NO_ELECTRONIC_REGISTRATION:
            return i18n.noDashEreg();

        case ECoachAbility.ANIMALS:
            return short
                ? i18n.animalsDashTitleDashShort()
                : i18n.animalsDashTitle();
        case ECoachAbility.ANIMALS_NEED_TO_BUY_TICKET_OFFLINE:
            return short
                ? i18n.animalsDashNeedDashToDashBuyDashTicketDashOfflineDashTitleDashShort()
                : i18n.animalsDashNeedDashToDashBuyDashTicketDashOfflineDashTitle();
        case ECoachAbility.GENDER_MALE:
            return i18n.abilityDashMaleDashTitle();
        case ECoachAbility.GENDER_FEMALE:
            return i18n.abilityDashFemaleDashTitle();
        case ECoachAbility.GENDER_MIXED:
            return i18n.abilityDashMixedDashTitle();
        case ECoachAbility.GENDER_SINGLE:
            return null;
    }
}
