import {ITrainsCoach, TrainsPassengersCount} from 'reducers/trains/order/types';
import {ECoachAbility} from 'types/trains/booking/ECoachAbility';

import getAvailableForSelectGendersForCoaches from 'projects/trains/lib/order/gender/getAvailableForSelectGendersForCoaches';
import {joinArrays, makeCacheable} from 'projects/trains/lib/cache';

/**
 * Функция проверяет, нужно ли для конкретного класса отображать иконку раздельных купе
 *
 * @param coaches - вагоны
 * @param passengers - пассажиры
 */
function shouldHideMixedGender(
    coaches: ITrainsCoach[],
    passengers: TrainsPassengersCount,
): boolean {
    return coaches.every(
        coach =>
            !coach.schemaId &&
            getAvailableForSelectGendersForCoaches(coaches, passengers).length <
                2,
    );
}

function getFacilitiesAndAbilitiesWithoutCache(
    abilities: string[],
    facilities: string[],
    coaches: ITrainsCoach[],
    passengers: TrainsPassengersCount,
): string[] {
    let facilityAndAbilityItems: string[] = joinArrays(abilities, facilities);

    // Для классов с быстрой кнопкой перехода на следующий шаг ("Указать пассажиров" прямо на классе)
    // не нужно отображать иконку гендерности, чтобы не вводить пользователя в заблуждение, что гендер можно выбрать.

    if (shouldHideMixedGender(coaches, passengers)) {
        facilityAndAbilityItems = facilityAndAbilityItems.filter(
            type => type !== ECoachAbility.GENDER_MIXED,
        );
    }

    return facilityAndAbilityItems;
}

/**
 * Функция возвращает особенности класса.
 */
export const getFacilitiesAndAbilities = makeCacheable(
    getFacilitiesAndAbilitiesWithoutCache,
);
