import _upperFirst from 'lodash/upperFirst';

import {ICoachServiceClass} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';

import * as i18nTrainsOrderConfirmBlock from 'i18n/trains-order-confirm';

export const getTrainsCoachClassLabelWithCode = (
    serviceClass: ICoachServiceClass,
): string =>
    _upperFirst(
        i18nTrainsOrderConfirmBlock.coachDashServiceDashClass({
            code: serviceClass.code,
        }),
    );
