import {FACILITIES_AND_ABILITIES} from 'projects/trains/components/TrainsOrderPage/Coach/components/CoachAdditionalInfo/components/CoachFacilitiesAndAbilities/utilities/constants';

import {ECoachAbility} from 'types/trains/booking/ECoachAbility';
import {ITrainsCoach, TrainsPassengersCount} from 'reducers/trains/order/types';
import {ECoachFacility} from 'types/trains/booking/ECoachFacility';
import {ICoachesSimpleClass} from 'projects/trains/components/TrainsOrderPage/SimpleSelectorView/types/TCoachesTypeGroups';

import {
    getReplacedFacilityType,
    getPreparedFacilityAndAbilityHint,
} from '../components/CoachFacilitiesAndAbilities/utilities/getFacilityAndAbilityHint';

import {getFacilitiesAndAbilities} from './getFacilitiesAndAbilities';

export const prepareTrainsFacilitiesAndAbilities = ({
    coach,
    passengers,
    activeClass,
}: {
    coach: ITrainsCoach;
    passengers: TrainsPassengersCount;
    activeClass?: ICoachesSimpleClass;
}): (ECoachFacility | ECoachAbility)[] => {
    if (!activeClass) {
        return [];
    }

    const facilitiesAndAbilities = getFacilitiesAndAbilities(
        activeClass.abilities,
        activeClass.facilities,
        [coach],
        passengers,
    );

    return FACILITIES_AND_ABILITIES.filter(item =>
        facilitiesAndAbilities.includes(item),
    )
        .map(getReplacedFacilityType)
        .filter(item => getPreparedFacilityAndAbilityHint(item));
};
