import {upperFirst} from 'lodash';

import {ITrainsCoach} from 'reducers/trains/order/types';
import {TTrainsStoreOrderSegment} from 'projects/trains/lib/segments/types';

import isSameISODateString from 'projects/trains/lib/date/isSameISODateString';
import {getThroughCoachArrivalTime} from 'projects/trains/lib/order/getThroughCoachArrivalTime';

import * as i18nBlock from 'i18n/trains-coach-properties';

export interface ITrainsCoachArrivalLabelTextParams {
    coach: ITrainsCoach;
    segment: TTrainsStoreOrderSegment;
    capitalize?: boolean;
}

interface ITrainsCoachArrivalLabelText {
    needToShowThroughCoachPrefix: boolean;
    text: string;
}

export function getCoachArrivalLabelText({
    capitalize,
    coach,
    segment,
}: ITrainsCoachArrivalLabelTextParams): ITrainsCoachArrivalLabelText {
    const arrival = getThroughCoachArrivalTime({
        segment,
        coach,
    });

    const needToShowThroughCoachPrefix = Boolean(
        coach.throughArrival &&
            !isSameISODateString(coach.throughArrival, segment.arrival),
    );

    const name = i18nBlock.throughDashCoachDashShort();
    const text = `${
        needToShowThroughCoachPrefix ? `${name}, ` : ''
    }${arrival}`.toLowerCase();

    return {
        needToShowThroughCoachPrefix,
        text: capitalize ? upperFirst(text) : text,
    };
}
