import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {ITrainsCoach} from 'reducers/trains/order/types';

import PriceScale from 'projects/trains/lib/order/priceScale/PriceScale';

import PriceLegend from 'projects/trains/components/TrainsOrderPage/PriceLegend/PriceLegend';

import cx from './CoachFooter.scss';

interface ICoachFooterProps extends IWithClassName {
    coach: ITrainsCoach;
    scale: PriceScale;
}

const CoachFooter: React.FC<ICoachFooterProps> = props => {
    const {className, scale, coach} = props;

    if (!coach.schemaId || !scale.isValid()) {
        return null;
    }

    const prices = scale.getDivision(coach, true);

    return (
        <div className={cx('root', className)}>
            <PriceLegend
                className={cx('pricesColumn')}
                coach={coach}
                prices={prices}
            />
        </div>
    );
};

export default CoachFooter;
