import React, {useMemo, useRef} from 'react';

import {IWithClassName} from 'types/withClassName';
import {ITrainsCoach} from 'reducers/trains/order/types';

import {deviceModMobile} from 'utilities/stylesUtils';
import {useBoolean} from 'utilities/hooks/useBoolean';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {getCoachNonRefundablePlaceNumbers} from 'projects/trains/lib/order/coaches/getCoachNonRefundablePlaceNumbers';

import * as i18nBlock from 'i18n/trainsNonRefundableTariffSelector';

import InfoIcon from 'icons/16/Info';
import Flex from 'components/Flex/Flex';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';
import NonRefundableTariffHelp from 'projects/trains/components/TrainsOrderPage/NonRefundableTariffHelp/NonRefundableTariffHelp';
import LabelNonRefundableDiscount from 'projects/trains/components/TrainsOrderPage/LabelNonRefundableDiscount/LabelNonRefundableDiscount';

import cx from './CoachNonRefundableDiscount.scss';

export interface ICoachNonRefundableDiscountProps extends IWithClassName {
    coach: ITrainsCoach;
}

const CoachNonRefundableDiscount: React.FC<ICoachNonRefundableDiscountProps> =
    props => {
        const {className, coach} = props;
        const deviceType = useDeviceType();
        const {
            value: isVisible,
            setFalse: closeTariffHelp,
            toggle: toggleTariffHelpVisibility,
        } = useBoolean(false);

        const coachDiscountPlaces = useMemo(
            () => getCoachNonRefundablePlaceNumbers({coach}),
            [coach],
        );

        const triggerRef = useRef(null);

        if (!coach.hasNonRefundableTariff || !coachDiscountPlaces.length) {
            return null;
        }

        return (
            <Flex
                inline
                nowrap
                between={deviceType.isMobile ? '1' : '2'}
                alignItems="center"
                className={className}
            >
                <LabelNonRefundableDiscount />
                <TextWithIcon
                    className={cx(
                        deviceModMobile('label', deviceType),
                        'label',
                    )}
                    iconRightClassName={cx('labelInfoIcon')}
                    iconRightRef={triggerRef}
                    size={deviceType.isMobile ? 's' : 'm'}
                    onClick={toggleTariffHelpVisibility}
                    spaceBetween={deviceType.isMobile ? '1' : '2'}
                    text={i18nBlock.nonRefundableDiscountLabel()}
                    iconRight={InfoIcon}
                />
                <NonRefundableTariffHelp
                    isVisible={isVisible}
                    places={coachDiscountPlaces}
                    triggerRef={triggerRef}
                    onClose={closeTariffHelp}
                />
            </Flex>
        );
    };

export default CoachNonRefundableDiscount;
