import {useEffect, useCallback} from 'react';

import {ITrainsCoach} from 'reducers/trains/order/types';
import {TTrainsStoreOrderSegment} from 'projects/trains/lib/segments/types';
import {EMetrikaTrainsSchemeErrorReason} from 'utilities/metrika/types/params/trains';

import {reachGoalOnceCoachSchemeLog} from 'projects/trains/components/TrainsOrderPage/Coach/utilities/reachGoalOnceCoachSchemeLog';

export interface IUseCoachSchemeLogProps {
    coach: ITrainsCoach;
    segment: TTrainsStoreOrderSegment;
    coachWithoutSchema: boolean;
}

export const useCoachSchemeLogAndCatchCallback = ({
    coach,
    segment,
    coachWithoutSchema,
}: IUseCoachSchemeLogProps): (() => void) => {
    useEffect(() => {
        reachGoalOnceCoachSchemeLog({
            coach,
            segment,
            logType: 'start',
        });
    }, [segment, coach]);

    useEffect(() => {
        if (coachWithoutSchema) {
            reachGoalOnceCoachSchemeLog({
                coach,
                segment,
                logType: 'error',
                errorReason: EMetrikaTrainsSchemeErrorReason.EMPTY_SCHEME_ID,
            });
        }
    }, [segment, coach, coachWithoutSchema]);

    return useCallback(() => {
        reachGoalOnceCoachSchemeLog({
            coach,
            segment,
            logType: 'error',
            errorReason: EMetrikaTrainsSchemeErrorReason.SCHEME_RENDER_ERROR,
        });
    }, [segment, coach]);
};
