import {TMetrikaParams} from 'utilities/metrika/types/params/all';
import {ITrainsCoach} from 'reducers/trains/order/types';
import {TTrainsStoreOrderSegment} from 'projects/trains/lib/segments/types';
import {EMetrikaTrainsSchemeErrorReason} from 'utilities/metrika/types/params/trains';

export const prepareCoachSchemeLogInfo = ({
    coach,
    segment,
    errorReason,
}: {
    coach: ITrainsCoach;
    segment: TTrainsStoreOrderSegment;
    errorReason?: EMetrikaTrainsSchemeErrorReason;
}): TMetrikaParams => {
    const {
        coachSubtypeCode,
        number: coachNumber,
        serviceClass: {code: serviceClassCode},
    } = coach;
    const {departure, number: trainNumber} = segment;

    return {
        trains: {
            schemeParams: {
                departure,
                errorReason,
                trainNumber,
                coachNumber,
                coachSubtypeCode,
                serviceClassCode,
            },
        },
    };
};
