import {ITrainsCoach} from 'reducers/trains/order/types';
import {TMetrikaGoal} from 'utilities/metrika/types/goals/all';
import {ETrainsGoal} from 'utilities/metrika/types/goals/trains';
import {ETrainsCoachType} from 'types/trains/common/tariffs/ETrainsCoachType';
import {TTrainsStoreOrderSegment} from 'projects/trains/lib/segments/types';
import {EMetrikaTrainsSchemeErrorReason} from 'utilities/metrika/types/params/trains';

import {reachGoal} from 'utilities/metrika';
import {prepareCoachSchemeLogInfo} from 'projects/trains/components/TrainsOrderPage/Coach/utilities/prepareCoachSchemeLogInfo';

const uniqCoachSchemeLogGoals = new Set();

export type TGoalOnceCoachSchemeLogType = 'start' | 'error';

export const MAP_COACH_TYPE_TO_METRIKA_EVENT_NAME: Record<
    ETrainsCoachType,
    Record<TGoalOnceCoachSchemeLogType, TMetrikaGoal>
> = {
    [ETrainsCoachType.SITTING]: {
        start: ETrainsGoal.PLACES_COACH_SITTING_SCHEME_START_RENDER,
        error: ETrainsGoal.PLACES_COACH_SITTING_SCHEME_ERROR,
    },
    [ETrainsCoachType.SUITE]: {
        start: ETrainsGoal.PLACES_COACH_SUITE_SCHEME_START_RENDER,
        error: ETrainsGoal.PLACES_COACH_SUITE_SCHEME_ERROR,
    },
    [ETrainsCoachType.COMMON]: {
        start: ETrainsGoal.PLACES_COACH_COMMON_SCHEME_START_RENDER,
        error: ETrainsGoal.PLACES_COACH_COMMON_SCHEME_ERROR,
    },
    [ETrainsCoachType.SOFT]: {
        start: ETrainsGoal.PLACES_COACH_SOFT_SCHEME_START_RENDER,
        error: ETrainsGoal.PLACES_COACH_SOFT_SCHEME_ERROR,
    },
    [ETrainsCoachType.COMPARTMENT]: {
        start: ETrainsGoal.PLACES_COACH_COMPARTMENT_SCHEME_START_RENDER,
        error: ETrainsGoal.PLACES_COACH_COMPARTMENT_SCHEME_ERROR,
    },
    [ETrainsCoachType.PLATZKARTE]: {
        start: ETrainsGoal.PLACES_COACH_PLATZKARTE_SCHEME_START_RENDER,
        error: ETrainsGoal.PLACES_COACH_PLATZKARTE_SCHEME_ERROR,
    },
};

const createUniqCoachTarget = ({
    target,
    coach,
    segment,
}: {
    target: TMetrikaGoal;
    coach: ITrainsCoach;
    segment: TTrainsStoreOrderSegment;
}): string => {
    const {number: coachNumber} = coach;
    const {departure, number: trainNumber} = segment;

    return [target, departure, trainNumber, coachNumber].join('_');
};

export const reachGoalOnceCoachSchemeLog = ({
    logType,
    coach,
    segment,
    errorReason,
}: {
    logType: TGoalOnceCoachSchemeLogType;
    coach: ITrainsCoach;
    segment: TTrainsStoreOrderSegment;
    errorReason?: EMetrikaTrainsSchemeErrorReason;
}): void => {
    if (typeof window === 'undefined') {
        return;
    }

    const {type: coachType} = coach;
    const target = MAP_COACH_TYPE_TO_METRIKA_EVENT_NAME[coachType]?.[logType];

    if (!target) {
        return;
    }

    const uniqCoachSchemeLogGoal = createUniqCoachTarget({
        target,
        coach,
        segment,
    });

    if (!uniqCoachSchemeLogGoals.has(uniqCoachSchemeLogGoal)) {
        uniqCoachSchemeLogGoals.add(uniqCoachSchemeLogGoal);

        const coachSchemeLogInfo = prepareCoachSchemeLogInfo({
            coach,
            segment,
            errorReason,
        });

        reachGoal(target, coachSchemeLogInfo);
    }
};
