import {GENDER_TYPE} from 'projects/trains/constants/genders';

import {ITrainsCoach, TrainsPassengersCount} from 'reducers/trains/order/types';
import {ITrainsSchema} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';
import {TTrainsStoreOrderSegment} from 'projects/trains/lib/segments/types';

import PriceScale from 'projects/trains/lib/order/priceScale/PriceScale';

export interface ICoachesTab {
    active: boolean;
    coachSchemaRenderingDelay: number;
    coach: ITrainsCoach;
    scale: PriceScale;
    schema: ITrainsSchema | null;
    gender: GENDER_TYPE | null;
    segment: TTrainsStoreOrderSegment;
    passengers: TrainsPassengersCount;
    orderPlaces: number[];
    showPrice: boolean;
    showNFCoach: boolean;
    withoutCoachNumberTitle: boolean;
    isDifferentCoachesArrival: boolean;
    schemaPlaceMaskPrefix: string;
}
