import {ITrainsCoach} from 'reducers/trains/order/types';

export default function getRepeatedCoachNumbers(
    coaches: ITrainsCoach[],
): Set<string> {
    const coachNumbersSet = new Set<string>();
    const repeatedCoachNumbersSet = new Set<string>();

    for (const coach of coaches) {
        if (coachNumbersSet.has(coach.number)) {
            repeatedCoachNumbersSet.add(coach.number);
        } else {
            coachNumbersSet.add(coach.number);
        }
    }

    return repeatedCoachNumbersSet;
}
