import React from 'react';

import {ORDER_PAGE_STATUSES} from 'projects/trains/constants/orderPageStatuses';

import {isFilledTrainsSearchContext} from 'reducers/trains/context/types';

import {deviceMods} from 'utilities/stylesUtils';
import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import * as i18nTrainsOrderConfirmBlock from 'i18n/trains-order-confirm';

import BookingLayout from 'components/Layouts/BookingLayout/BookingLayout';
import Places from './components/Places/Places';
import Passengers from './components/Passengers/Passengers';
import Contacts from './components/Contacts/Contacts';
import ConfirmationTimer from 'projects/trains/components/TrainsOrderPage/OrderTimer/ConfirmationTimer';
import Heading from 'components/Heading/Heading';
import TrainsOrderSegments from 'projects/trains/components/TrainsOrderSegments/TrainsOrderSegments';

import {TConfirmStepProps} from './ConfirmStepContainer';

import cx from './ConfirmStep.scss';

const ConfirmStep: React.FC<TConfirmStepProps> = props => {
    const {
        context,
        order,
        deviceType,
        trainSegments,
        orderPageStatus,
        orderTripInfo,
        goBackToChangePlaces,
    } = props;
    const {isMobile, isDesktop} = deviceType;
    const {orderInfo} = order;

    if (!isFilledTrainsSearchContext(context)) {
        return null;
    }

    return (
        <div
            className={cx('root', deviceMods('root', deviceType))}
            {...prepareQaAttributes(props)}
        >
            <BookingLayout.Forms>
                {isMobile && orderInfo?.expiresAt && (
                    <ConfirmationTimer
                        orderInfo={orderInfo}
                        deviceType={deviceType}
                    />
                )}

                <Heading className={cx('header')} level={isDesktop ? 2 : 3}>
                    {i18nTrainsOrderConfirmBlock.headerTrainTitle()}
                </Heading>

                <TrainsOrderSegments
                    segments={trainSegments}
                    tripInfo={orderTripInfo}
                    loading={
                        orderPageStatus === ORDER_PAGE_STATUSES.FETCHING_DATA
                    }
                    showETicketBadge
                    {...prepareQaAttributes('trainsOrderSegments')}
                />

                <BookingLayout.Card paddingBottom={isDesktop ? 8 : 5}>
                    <Places
                        context={context}
                        order={order}
                        goBackToChangePlaces={goBackToChangePlaces}
                        {...prepareQaAttributes(props)}
                    />
                </BookingLayout.Card>

                <BookingLayout.Card paddingBottom={isMobile ? 5 : 7}>
                    <Passengers
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'passengers',
                        })}
                    />
                </BookingLayout.Card>

                <BookingLayout.Card>
                    <Contacts
                        userInfo={order.orderInfo?.contactInfo}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'contacts',
                        })}
                    />
                </BookingLayout.Card>
            </BookingLayout.Forms>
        </div>
    );
};

export default ConfirmStep;
