import React, {useEffect} from 'react';
import {connect} from 'react-redux';
import {RouteComponentProps, withRouter} from 'react-router-dom';

import {EOrderErrorType} from 'projects/trains/constants/orderErrors';

import {isFilledTrainsSearchContext} from 'reducers/trains/context/types';
import {ETrainsGoal} from 'utilities/metrika/types/goals/trains';

import {setInsuranceIncluded} from 'reducers/trains/order/actions/userChoice';
import {setOrderError as setOrderErrorAction} from 'reducers/trains/order/actions/view';
import choosePlacesAgain from 'reducers/trains/order/thunk/choosePlacesAgain';

import trainsConfirmOrderStepSelector from 'selectors/trains/trainsConfirmOrderStepSelector';

import {reachGoal} from 'utilities/metrika';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/trains-error-page-order';

import ConfirmStep from 'projects/trains/components/TrainsOrderPage/ConfirmStep/ConfirmStep';

const mapDispatchToProps = {
    goBackToChangePlaces: choosePlacesAgain,
    setInsurance: setInsuranceIncluded,
    setOrderError: setOrderErrorAction,
};

export const CONFIRM_STEP_QA = 'confirmStep';

export type TConfirmStepProps = ReturnType<
    typeof trainsConfirmOrderStepSelector
> &
    typeof mapDispatchToProps &
    IWithQaAttributes &
    RouteComponentProps;

const ConfirmStepContainer: React.FC<TConfirmStepProps> = props => {
    const {
        order: {orderInfo, error: orderError},
        context,
        setOrderError,
    } = props;

    useEffect(() => {
        if (!isFilledTrainsSearchContext(context)) {
            return;
        }

        reachGoal(ETrainsGoal.ORDER_CONFIRM_PAGE_LOAD);
    }, [context]);

    useEffect(() => {
        if (!orderInfo && !orderError) {
            setOrderError({
                type: EOrderErrorType.EMPTY_ORDER_DETAILS,
                title: i18nBlock.emptyDashOrderDashDetails(),
            });
        }
    }, [orderError, orderInfo, setOrderError]);

    if (!isFilledTrainsSearchContext(context)) {
        return null;
    }

    return <ConfirmStep {...props} {...prepareQaAttributes(CONFIRM_STEP_QA)} />;
};

export default withRouter(
    connect(
        trainsConfirmOrderStepSelector,
        mapDispatchToProps,
    )(ConfirmStepContainer),
);
