import React from 'react';

import IContactInfo from 'server/api/GenericOrderApi/types/common/IContactInfo';

import {formatRussianPhoneNumber} from 'projects/trains/lib/order/fields/phone';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nTrainsOrderConfirmBlock from 'i18n/trains-order-confirm';
import * as i18nTrainsOrderContactsBlock from 'i18n/trains-order-contacts';

import Heading from 'components/Heading/Heading';
import Flex from 'components/Flex/Flex';
import FieldLabel from 'components/FieldLabel/FieldLabel';

interface IContactsProps extends IWithQaAttributes {
    userInfo: IContactInfo | undefined;
}

const Contacts: React.FC<IContactsProps> = props => {
    const {userInfo} = props;

    const deviceType = useDeviceType();

    if (!userInfo) {
        return null;
    }

    return (
        <Flex
            flexDirection="column"
            between={4}
            {...prepareQaAttributes(props)}
        >
            <Heading level={deviceType.isDesktop ? 2 : 3}>
                {i18nTrainsOrderConfirmBlock.headerDashContactsDashRedesign()}
            </Heading>
            <Flex
                inline={deviceType.isDesktop}
                between={deviceType.isDesktop ? 8 : 4}
                flexDirection={deviceType.isDesktop ? 'row' : 'column'}
            >
                <FieldLabel
                    label={i18nTrainsOrderContactsBlock.email()}
                    {...prepareQaAttributes({parent: props, current: 'email'})}
                >
                    {userInfo.email}
                </FieldLabel>
                <FieldLabel
                    label={i18nTrainsOrderContactsBlock.phoneDashRedesign()}
                    {...prepareQaAttributes({parent: props, current: 'phone'})}
                >
                    {formatRussianPhoneNumber(userInfo.phone)}
                </FieldLabel>
            </Flex>
        </Flex>
    );
};

export default Contacts;
