import React from 'react';
import {useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';

import passengersBlockSelector from 'projects/trains/components/TrainsOrderPage/ConfirmStep/components/Passengers/selectors/passengersBlockSelector';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {deviceMods} from 'utilities/stylesUtils';

import * as i18nTrainsOrderConfirmBlock from 'i18n/trains-order-confirm';

import Heading from 'components/Heading/Heading';
import Separator from 'components/Separator/Separator';
import Flex from 'components/Flex/Flex';
import Passenger from './components/Passenger/Passenger';
import Intersperse from 'components/Intersperse/Intersperse';

import cx from './Passengers.scss';

interface IPassengersProps extends IWithClassName, IWithQaAttributes {}

const Passengers: React.FC<IPassengersProps> = props => {
    const {className} = props;
    const {deviceType, passengerTicketsInfo, multipleTrainsInOrder} =
        useSelector(passengersBlockSelector);

    if (!passengerTicketsInfo) {
        return null;
    }

    return (
        <div
            className={cx(className, 'root', deviceMods('root', deviceType))}
            {...prepareQaAttributes(props)}
        >
            <Heading
                level={deviceType.isDesktop ? 2 : 3}
                className={cx('header')}
            >
                {i18nTrainsOrderConfirmBlock.headerDashPassengersDashTitle()}
            </Heading>

            {deviceType.isDesktop && (
                <Separator className={cx('headerSeparator')} />
            )}

            <Flex flexDirection="column">
                <Intersperse
                    separator={
                        <Separator className={cx('passengerSeparator')} />
                    }
                >
                    {passengerTicketsInfo.map(({passenger, tickets, baby}) => (
                        <Passenger
                            key={passenger.customerId}
                            className={cx('passenger')}
                            passenger={passenger}
                            baby={baby}
                            tickets={tickets}
                            needPrintPlace={passengerTicketsInfo.length > 1}
                            multipleTrains={multipleTrainsInOrder}
                            {...prepareQaAttributes({
                                parent: props,
                                current: 'passenger',
                                key: passenger.customerId,
                            })}
                        />
                    ))}
                </Intersperse>
            </Flex>
        </div>
    );
};

export default Passengers;
