import {createSelector} from 'reselect';

import orderInfoSelector from 'selectors/trains/order/orderInfoSelector';

import {getTrainServices} from 'projects/trains/lib/order/getTrainServices';
import {
    IPassengerWithTickets,
    getPassengerWithTicketsListByGenericOrderServices,
} from 'projects/trains/lib/order/getPassengerWithTicketsListByGenericOrderServices';

export default createSelector(
    [orderInfoSelector],
    (orderInfo): IPassengerWithTickets[] | null => {
        if (!orderInfo) {
            return null;
        }

        const services = getTrainServices(orderInfo);

        return getPassengerWithTicketsListByGenericOrderServices(services);
    },
);
