import React, {useCallback, useEffect} from 'react';

import {ETrainsGoal} from 'utilities/metrika/types/goals/trains';
import {IWithClassName} from 'types/withClassName';
import {ITrainsDirectionAndIndex} from 'types/trains/common/segment/ITrainsDirectionAndIndex';

import {reachGoal} from 'utilities/metrika';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import * as i18nBlock from 'i18n/trains-order-confirm';

import Button from 'components/Button/Button';
import Flex from 'components/Flex/Flex';

import cx from './ChangedPlacesNotification.scss';

interface IChangedPlacesNotificationProps extends IWithClassName {
    directionAndIndex?: ITrainsDirectionAndIndex;

    goBackToChangePlaces(directionAndIndex?: ITrainsDirectionAndIndex): void;
}

const ChangedPlacesNotification: React.FC<IChangedPlacesNotificationProps> =
    props => {
        const {className, directionAndIndex, goBackToChangePlaces} = props;

        const deviceType = useDeviceType();

        useEffect(() => {
            reachGoal(ETrainsGoal.PLACES_CHANGE_DIALOG_SHOW);
        }, []);

        const handleGoBackToChangePlaces = useCallback(() => {
            goBackToChangePlaces(directionAndIndex);

            reachGoal(ETrainsGoal.PLACES_CHANGE_DIALOG_RETURN);
        }, [goBackToChangePlaces, directionAndIndex]);

        return (
            <Flex
                className={cx(
                    className,
                    'root',
                    deviceMods('root', deviceType),
                )}
                inline={deviceType.isDesktop}
                between={deviceType.isDesktop ? 5 : 4}
                flexDirection={deviceType.isDesktop ? 'row' : 'column'}
                alignItems={'center'}
                nowrap={deviceType.isDesktop}
            >
                <div>{i18nBlock.changedDashPlacesDashText()}</div>

                <Button
                    className={cx('button')}
                    size={'l'}
                    theme={'raised'}
                    onClick={handleGoBackToChangePlaces}
                >
                    {i18nBlock.changedDashPlacesDashButton()}
                </Button>
            </Flex>
        );
    };

export default ChangedPlacesNotification;
