import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {ITrainsDirectionAndIndex} from 'types/trains/common/segment/ITrainsDirectionAndIndex';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Flex from 'components/Flex/Flex';
import ChangedPlacesNotification from 'projects/trains/components/TrainsOrderPage/ConfirmStep/components/Places/components/ChangedPlacesNotification/ChangedPlacesNotification';
import PupilNotification from 'projects/trains/components/TrainsOrderPage/ConfirmStep/components/Places/components/PlacesNotifications/components/PupilNotification/PupilNotification';

import cx from './PlacesNotifications.scss';

interface IPlacesNotificationsProps extends IWithClassName {
    showChangedPlacesNotification: boolean;

    goBackToChangePlaces(directionAndIndex?: ITrainsDirectionAndIndex): void;
}

const PlacesNotifications: React.FC<IPlacesNotificationsProps> = props => {
    const {className, showChangedPlacesNotification, goBackToChangePlaces} =
        props;
    const deviceType = useDeviceType();

    return (
        <Flex
            className={cx(className, 'root', deviceMods('root', deviceType))}
            flexDirection={'column'}
            between={1}
        >
            {showChangedPlacesNotification && (
                <ChangedPlacesNotification
                    className={cx('notificationItem')}
                    goBackToChangePlaces={goBackToChangePlaces}
                />
            )}

            <PupilNotification className={cx('notificationItem')} />
        </Flex>
    );
};

export default PlacesNotifications;
