import React from 'react';
import {useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';

import hasPupilPassengerSelector from 'projects/trains/components/TrainsOrderPage/ConfirmStep/selectors/hasPupilPassengerSelector';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18nBlock from 'i18n/trains-order-confirm';

import Link from 'components/Link/Link';

interface IPupilNotificationProps extends IWithClassName {}

const PupilNotification: React.FC<IPupilNotificationProps> = props => {
    const {className} = props;

    const hasPupilPassenger = useSelector(hasPupilPassengerSelector);

    if (!hasPupilPassenger) {
        return null;
    }

    return (
        <div className={className}>
            {insertJSXIntoKey(i18nBlock.pupilDashNotification)({
                link: (
                    <Link
                        key="link"
                        url={i18nBlock.pupilDashNotificationDashLink()}
                        target="_blank"
                        rel="noopener noreferrer"
                    >
                        {i18nBlock.pupilDashNotificationDashLinkDashText()}
                    </Link>
                ),
            })}
        </div>
    );
};

export default React.memo(PupilNotification);
