import React, {useMemo} from 'react';

import {ITrainsFilledSearchContext} from 'reducers/trains/context/types';
import {IWithClassName} from 'types/withClassName';
import {ITrainsDirectionAndIndex} from 'types/trains/common/segment/ITrainsDirectionAndIndex';
import {EDirection} from 'types/common/EDirection';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import PrintTicketsNotification from './components/PrintTicketsNotification/PrintTicketsNotification';
import Flex from 'components/Flex/Flex';

import ChangedPlacesNotification from '../../../ChangedPlacesNotification/ChangedPlacesNotification';

import cx from './TrainNotifications.scss';

interface ITrainNotificationsProps extends IWithClassName {
    context: ITrainsFilledSearchContext;
    direction: EDirection;
    index: number;
    eTicketStatus: boolean;
    showChangedPlacesNotification: boolean;

    goBackToChangePlaces(directionAndIndex?: ITrainsDirectionAndIndex): void;
}

const TrainNotifications: React.FC<ITrainNotificationsProps> = props => {
    const {
        className,
        context,
        direction,
        index,
        eTicketStatus,
        showChangedPlacesNotification,
        goBackToChangePlaces,
    } = props;
    const deviceType = useDeviceType();
    const directionAndIndex = useMemo(
        () => ({direction, index}),
        [direction, index],
    );

    return (
        <Flex
            className={cx(className, 'root', deviceMods('root', deviceType))}
            flexDirection={'column'}
            between={1}
        >
            {showChangedPlacesNotification && (
                <ChangedPlacesNotification
                    className={cx('notificationItem')}
                    directionAndIndex={directionAndIndex}
                    goBackToChangePlaces={goBackToChangePlaces}
                />
            )}

            <PrintTicketsNotification
                className={cx('notificationItem')}
                context={context}
                eTicketStatus={eTicketStatus}
            />
        </Flex>
    );
};

export default TrainNotifications;
