import React from 'react';

import {
    ALLOW_INSIDE_COUNTY_BOOKING_COUNTRIES,
    COUNTRY_CODE_RU,
} from 'projects/trains/constants/countries';

import {ITrainsFilledSearchContext} from 'reducers/trains/context/types';
import {IWithClassName} from 'types/withClassName';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18nBlock from 'i18n/trains-order-confirm';

import Link from 'components/Link/Link';

interface IPrintTicketsNotificationProps extends IWithClassName {
    context: ITrainsFilledSearchContext;
    eTicketStatus: boolean;
}

/**
 * Предупреждение о том, что нужно получить посадочный купон на территории РФ.
 */
const PrintTicketsNotification: React.FC<IPrintTicketsNotificationProps> =
    props => {
        const {
            className,
            context: {
                from: {
                    country: {code: fromCode},
                },
            },
            eTicketStatus,
        } = props;

        if (
            eTicketStatus ||
            fromCode === COUNTRY_CODE_RU ||
            !ALLOW_INSIDE_COUNTY_BOOKING_COUNTRIES.includes(fromCode)
        ) {
            return null;
        }

        return (
            <div className={className}>
                {insertJSXIntoKey(
                    i18nBlock.printDashTicketsDashNotificationDashNew,
                )({
                    link: (
                        <Link
                            key="link"
                            url={i18nBlock.printDashTicketsDashNotificationDashLink()}
                            target="_blank"
                            rel="noopener noreferrer"
                        >
                            {i18nBlock.printDashTicketsDashNotificationDashLinkDashText()}
                        </Link>
                    ),
                })}
            </div>
        );
    };

export default React.memo(PrintTicketsNotification);
