import {TRAIN_FEATURES_TYPES} from 'projects/trains/lib/segments/features/types';

import {TrainsOrderStateInterface} from 'reducers/trains/order/reducer';

import {getTrainFeatures} from 'projects/trains/lib/segments/features/getTrainFeatures';
import getFirstForwardSegment from 'projects/trains/lib/complexOrder/getFirstForwardSegment';

export function getTrainFeatureContent(
    order: TrainsOrderStateInterface,
    featureType: TRAIN_FEATURES_TYPES,
): string {
    const segment = getFirstForwardSegment(order);

    if (!segment) {
        return '';
    }

    const feature = getTrainFeatures(segment).find(
        feature => feature.type === featureType,
    );

    return feature?.content ?? '';
}
