import {createSelector} from 'reselect';

import {ITrainsDirectionAndIndex} from 'types/trains/common/segment/ITrainsDirectionAndIndex';

import orderInfoSelector from 'selectors/trains/order/orderInfoSelector';
import trainsSelector from 'selectors/trains/order/trainsSelector';

import {
    diffPlaces,
    getActualPlaces,
    havePlacesChanged,
} from 'projects/trains/lib/order/places';
import {getTrainServices} from 'projects/trains/lib/order/getTrainServices';

export default createSelector(
    [orderInfoSelector, trainsSelector],
    (orderInfo, trains): ITrainsDirectionAndIndex[] => {
        if (!orderInfo) {
            return [];
        }

        return getTrainServices(orderInfo).reduce<ITrainsDirectionAndIndex[]>(
            (changedPlacesSegments, trainService) => {
                const {direction, segmentIndex, passengers} =
                    trainService.trainInfo;
                const train = trains[direction][segmentIndex];

                if (!train) {
                    return changedPlacesSegments;
                }

                const orderPlaces = train.orderPlaces;
                const actualPlaces = getActualPlaces(passengers);

                if (!havePlacesChanged(diffPlaces(orderPlaces, actualPlaces))) {
                    return changedPlacesSegments;
                }

                return [
                    ...changedPlacesSegments,
                    {direction, index: segmentIndex},
                ];
            },
            [],
        );
    },
);
