import {createSelector} from 'reselect';

import {TrainBookedTariffCode} from 'server/api/TrainsBookingApi/types/ITrainsOrderInfoTicket';

import orderInfoSelector from 'selectors/trains/order/orderInfoSelector';

import {getTrainServices} from 'projects/trains/lib/order/getTrainServices';

export default createSelector([orderInfoSelector], (orderInfo): boolean => {
    if (!orderInfo) {
        return false;
    }

    return getTrainServices(orderInfo).some(trainService =>
        trainService.trainInfo.passengers.some(
            ({ticket}) =>
                ticket?.bookedTariffCode === TrainBookedTariffCode.PUPIL ||
                ticket?.tariffInfo?.code === 'pupil',
        ),
    );
});
