import React, {useMemo} from 'react';

import * as i18nBlock from 'i18n/trains-error-page-common';

import LayoutError500 from 'components/Layouts/LayoutError500/LayoutError500';
import {TErrorActionType} from 'components/ErrorModal/ErrorModal';

import cx from './ErrorPage.scss';

interface IErrorPageProps {
    errorData: {
        description?: string;
        solution?: string;
    };
    withoutAction?: boolean;
}

const ErrorPage: React.FC<IErrorPageProps> = props => {
    const {
        errorData: {description, solution},
        withoutAction = false,
    } = props;

    const action = useMemo(
        (): TErrorActionType | undefined =>
            withoutAction
                ? undefined
                : {
                      type: 'button',
                      title: i18nBlock.actionText(),
                      handler: (): void => {
                          document.location.reload();
                      },
                  },
        [withoutAction],
    );

    return (
        <div className={cx('root')}>
            <LayoutError500
                title={description}
                subtitle={solution}
                action={action}
            />
        </div>
    );
};

export default ErrorPage;
