import React from 'react';

import {GENDER_TYPE} from 'projects/trains/constants/genders';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import GenderPopupDesktop from 'projects/trains/components/TrainsOrderPage/GenderPopup/components/GenderPopupDesktop/GenderPopupDesktop';
import GenderPopupMobile from 'projects/trains/components/TrainsOrderPage/GenderPopup/components/GenderPopupMobile/GenderPopupMobile';

export interface IGenderPopupProps extends IWithClassName {
    gender: GENDER_TYPE | null;
    visible: boolean;
    anchor: HTMLElement | null;
    onClose(): void;
    onChange(): void;
}

const GenderPopup: React.FC<IGenderPopupProps> = props => {
    const deviceType = useDeviceType();

    if (deviceType.isMobile) {
        return <GenderPopupMobile {...props} />;
    }

    return <GenderPopupDesktop {...props} />;
};

export default GenderPopup;
