import React, {useMemo} from 'react';

import EPopupDirection from 'components/Popup/types/EPopupDirection';

import * as i18nBlock from 'i18n/trains-transport-schema';

import {IGenderPopupProps} from 'projects/trains/components/TrainsOrderPage/GenderPopup/GenderPopup';
import GenderSelector from 'projects/trains/components/TrainsOrderPage/GenderSelector/GenderSelector';
import MessageBoxPopup from 'components/MessageBoxPopup/MessageBoxPopup';

import cx from './GenderPopupDesktop.scss';

const POPUP_DIRECTIONS = [
    EPopupDirection.BOTTOM,
    EPopupDirection.BOTTOM_LEFT,
    EPopupDirection.BOTTOM_RIGHT,
    EPopupDirection.TOP,
    EPopupDirection.TOP_LEFT,
    EPopupDirection.TOP_RIGHT,
];

const GenderPopupDesktop: React.FC<IGenderPopupProps> = props => {
    const {gender, visible, onChange, onClose, anchor} = props;

    const anchorRef = useMemo(() => {
        return {
            current: anchor,
        };
    }, [anchor]);

    return (
        <MessageBoxPopup
            isVisible={visible}
            anchorRef={anchorRef}
            direction={POPUP_DIRECTIONS}
            onClose={onClose}
        >
            <section className={cx('content')}>
                <h4 className={cx('title')}>
                    {i18nBlock.selectDashGenderDashTitle()}
                </h4>

                <p className={cx('text')}>
                    {i18nBlock.selectDashGenderDashText({link: false})}
                </p>

                <GenderSelector
                    value={gender || undefined}
                    className={cx('selector')}
                    onChange={onChange}
                />
            </section>
        </MessageBoxPopup>
    );
};

export default GenderPopupDesktop;
