import React from 'react';

import {IWithClassName} from 'types/withClassName';

import Label, {ECornersType, ELabelThemeType} from 'components/Label/Label';

import cx from './LabelNonRefundableDiscount.scss';

interface ILabelNonRefundableDiscountProps extends IWithClassName {}

const LabelNonRefundableDiscount: React.FC<ILabelNonRefundableDiscountProps> =
    props => {
        const {className} = props;

        return (
            <Label
                className={cx(className)}
                size="s"
                cornersType={ECornersType.ROUNDED}
                theme={ELabelThemeType.ATTENTION}
            >
                <span className={cx('discountText')}>%</span>
            </Label>
        );
    };

export default LabelNonRefundableDiscount;
