import React, {Component} from 'react';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/trains-error-page-order';

import {IOrderErrorPropTypes} from 'projects/trains/components/TrainsOrderPage/OrderError';
import ErrorModal, {TErrorActionType} from 'components/ErrorModal/ErrorModal';

import cx from './styles.scss';

const MODAL_QA = 'orderError';

export default class BaseError extends Component<IOrderErrorPropTypes> {
    protected onChoosePlacesClick = this.props.choosePlaces;

    protected getErrorTitle(): string {
        const {error} = this.props;

        return error?.title || i18nBlock.ufsDashErrorDashCommonDashTitle();
    }

    protected getErrorMessage(): React.ReactNode | undefined {
        const {error} = this.props;

        return error?.message;
    }

    protected getErrorAdditionalData(): React.ReactNode {
        const {error} = this.props;

        if (!error?.params?.length) {
            return null;
        }

        return (
            <ul className={cx('errorList')}>
                {error.params.map((item: string, index: number) => (
                    <li className={cx('errorListItem')} key={index}>
                        {item}
                    </li>
                ))}
            </ul>
        );
    }

    protected getErrorContent(): React.ReactNode {
        return (
            <div>
                {this.getErrorMessage()}

                {this.getErrorAdditionalData()}
            </div>
        );
    }

    protected getPrimaryErrorAction(): TErrorActionType {
        return {
            type: 'button',
            handler: this.onChoosePlacesClick,
            title: i18nBlock.buttonDashToDashPlacesDashStep(),
        };
    }

    protected getSecondaryErrorAction(): TErrorActionType | undefined {
        return undefined;
    }

    render(): React.ReactNode {
        const {error} = this.props;

        if (!error?.type) {
            return null;
        }

        return (
            <ErrorModal
                isVisible
                title={this.getErrorTitle()}
                primaryAction={this.getPrimaryErrorAction()}
                secondaryAction={this.getSecondaryErrorAction()}
                {...prepareQaAttributes(MODAL_QA)}
            >
                {this.getErrorContent()}
            </ErrorModal>
        );
    }
}
