import {IOrderError} from 'reducers/trains/order/types';

import {
    LOYALTY_CARDS_ERROR_CODES,
    PLACES_ERROR_CODES,
    EUFSErrorCodes,
} from 'projects/trains/lib/errors/orderErrors';
import getUFCCodeText from 'projects/trains/components/TrainsOrderPage/OrderError/CommonError/utilities/getUFCCodeText';

import * as i18nBlock from 'i18n/trains-error-page-order';

import BaseError from 'projects/trains/components/TrainsOrderPage/OrderError/BaseError';
import {TErrorActionType} from 'components/ErrorModal/ErrorModal';

export default class CommonError extends BaseError {
    protected getErrorTitle(): string {
        const {data, title} = this.props.error as IOrderError;
        const code = data && data.code;

        if (PLACES_ERROR_CODES.includes(code as EUFSErrorCodes)) {
            return i18nBlock.ufsDashErrorDashNoDashPlacesDashTitle();
        }

        return title || i18nBlock.ufsDashErrorDashCommonDashTitle();
    }

    protected getErrorMessage(): React.ReactNode | undefined {
        const {data, message} = this.props.error as IOrderError;
        const code = data?.code;

        if (!code) {
            return message;
        }

        if (
            (code === EUFSErrorCodes.TRAIN_DEPARTS_SOON ||
                code === EUFSErrorCodes.REPEATED_RESERVATION) &&
            message &&
            typeof message === 'string'
        ) {
            const matches = /(\d+) (часа|минут)/gi.exec(message);
            const number = matches?.[1];

            if (number === undefined) {
                return getUFCCodeText(code);
            }

            return getUFCCodeText(code, {number});
        }

        const ufcErrorMessage = getUFCCodeText(code);

        if (ufcErrorMessage) {
            return ufcErrorMessage;
        }

        return message;
    }

    protected getPrimaryErrorAction(): TErrorActionType {
        const code = this.props.error?.data?.code;

        if (LOYALTY_CARDS_ERROR_CODES.includes(code as EUFSErrorCodes)) {
            return {
                type: 'button',
                handler: this.props.choosePassengers,
                title: i18nBlock.buttonDashToDashPassengersDashStep(),
            };
        }

        return super.getPrimaryErrorAction();
    }
}
