import {EUFSErrorCodes} from 'projects/trains/lib/errors/orderErrors';

import * as i18n from 'i18n/trains-error-page-order';

export default function getUFCCodeText(
    code: EUFSErrorCodes,
    params?: {number: string},
): string | null {
    switch (code) {
        case EUFSErrorCodes.TRAIN_DEPARTS_SOON:
            return params
                ? i18n.ufsDashErrorDashCodeDash5414(params)
                : i18n.ufsDashErrorDashCodeDash5414DashNoDashParams();
        case EUFSErrorCodes.REPEATED_RESERVATION:
            return params
                ? i18n.ufsDashErrorDashCodeDash5043(params)
                : i18n.ufsDashErrorDashCodeDash5043DashNoDashParams();

        case EUFSErrorCodes.NO_PLACES_ON_DIRECTION:
            return i18n.ufsDashErrorDashCodeDash5060();
        case EUFSErrorCodes.NO_PLACES_FOR_GIVEN_PARAMETERS:
            return i18n.ufsDashErrorDashCodeDash5068();
        case EUFSErrorCodes.NO_PLACES_IN_SELECTED_CAR:
            return i18n.ufsDashErrorDashCodeDash5371();
        case EUFSErrorCodes.NO_PLACES_IN_SAME_COMPARTMENT:
            return i18n.ufsDashErrorDashCodeDash5382();
        case EUFSErrorCodes.LOYALTY_CARDS_ADULT_PASSENGERS_ONLY:
            return i18n.ufsDashErrorDashCodeDash5301();
        case EUFSErrorCodes.NO_PLACES_BOTTOM_OR_NEAR_WINDOW:
        case EUFSErrorCodes.ONLY_SIDE_PLACES:
            return i18n.ufsDashErrorDashCodeDashNoDashPlaces();
        case EUFSErrorCodes.PASSENGERS_DATA_DOES_NOT_CORRESPOND_TO_CARDHOLDER_DATA_1:
        case EUFSErrorCodes.PASSENGERS_DATA_DOES_NOT_CORRESPOND_TO_CARDHOLDER_DATA_2:
        case EUFSErrorCodes.PASSENGERS_DATA_DOES_NOT_CORRESPOND_TO_CARDHOLDER_DATA_3:
            return i18n.ufsDashErrorDashCodeDashIncorrectDashPassenger();
        case EUFSErrorCodes.INCORRECT_LOYALTY_CARD_NUMBER_1:
        case EUFSErrorCodes.INCORRECT_LOYALTY_CARD_NUMBER_2:
            return i18n.ufsDashErrorDashCodeDashIncorrectDashCardDashNumber();
    }
}
