import * as i18nBlock from 'i18n/trains-error-page-order';

import BaseError from 'projects/trains/components/TrainsOrderPage/OrderError/BaseError';
import {TErrorActionType} from 'components/ErrorModal/ErrorModal';

export default class InsuranceError extends BaseError {
    private onSkip = this.props.skipInsuranceError;

    protected getPrimaryErrorAction(): TErrorActionType {
        return {
            type: 'button',
            handler: this.onSkip,
            title: i18nBlock.insuranceDashErrorDashSkip(),
        };
    }

    protected getSecondaryErrorAction(): TErrorActionType {
        return {
            type: 'button',
            handler: this.onChoosePlacesClick,
            title: i18nBlock.buttonDashToDashPlacesDashStep(),
        };
    }

    protected getErrorTitle(): string {
        return i18nBlock.insuranceDashErrorDashTitle();
    }

    protected getErrorMessage(): string {
        return i18nBlock.insuranceDashErrorDashMessage();
    }
}
