import * as i18nBlock from 'i18n/trains-error-page-order';

import BaseError from 'projects/trains/components/TrainsOrderPage/OrderError/BaseError';
import {TErrorActionType} from 'components/ErrorModal/ErrorModal';

export default class PaymentError extends BaseError {
    protected getPrimaryErrorAction(): TErrorActionType {
        return {
            type: 'button',
            handler: this.props.resetPayment,
            title: i18nBlock.buttonDashToDashResetDashPayment(),
        };
    }

    protected getSecondaryErrorAction(): TErrorActionType {
        return {
            type: 'button',
            handler: this.onChoosePlacesClick,
            title: i18nBlock.buttonDashToDashPlacesDashStep(),
        };
    }
}
