import React from 'react';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';
import {trainsURLs} from 'projects/trains/lib/urls';

import * as i18nBlock from 'i18n/trains-error-page-order';

import BaseError from 'projects/trains/components/TrainsOrderPage/OrderError/BaseError';
import SupportPhone from 'components/SupportPhone/SupportPhone';
import Link from 'components/Link/Link';

export default class ProcessExceptionStateError extends BaseError {
    protected getErrorMessage(): React.ReactNode | undefined {
        const message = this.props.error?.message;

        if (message) {
            return message;
        }

        const feedbackLink = (
            <Link
                theme="normal"
                target="_blank"
                url={trainsURLs.getOrderFeedbackUrl()}
            >
                {i18nBlock.processExceptionStateDescriptionFeedbackDashLink()}
            </Link>
        );

        return insertJSXIntoKey(
            i18nBlock.processExceptionStateDescriptionSupportDashPhone,
        )({
            supportPhone: <SupportPhone />,
            link: true,
            feedbackLink,
            orderNumber: false,
        });
    }
}
