import React from 'react';
import moment from 'moment-timezone';

import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';

import {deviceMods} from 'utilities/stylesUtils';
import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/trains-order-payment';

import Text from 'components/Text/Text';
import withTimer, {
    IBaseOrderTimerProps,
} from 'projects/trains/components/TrainsOrderPage/OrderTimer/OrderTimerContainer';

import cx from './ConfirmationTimer.scss';

const ROOT_QA = 'confirmationTimer';

interface IConfirmationTimerProps
    extends IBaseOrderTimerProps,
        IWithDeviceType,
        IWithClassName {}

const ConfirmationTimer: React.FC<IConfirmationTimerProps> = props => {
    const {className, deviceType, isHighlighted, timeLeft} = props;

    return (
        <div
            className={cx('root', className, deviceMods('root', deviceType), {
                root_highlighted: isHighlighted,
            })}
            {...prepareQaAttributes(ROOT_QA)}
        >
            <Text
                className={cx('countdown')}
                weight="bold"
                size="m"
                color={isHighlighted ? 'alert' : 'primary'}
                {...prepareQaAttributes({parent: ROOT_QA, current: 'time'})}
            >
                {moment(timeLeft).format('mm:ss')}
            </Text>

            <Text size="m" color={isHighlighted ? 'alert' : 'primary'}>
                {i18nBlock.paymentDashTimerDashDescription()}
            </Text>
        </div>
    );
};

export default withTimer<IConfirmationTimerProps>(ConfirmationTimer);
