import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';

import {deviceMods} from 'utilities/stylesUtils';

import * as i18nBlock from 'i18n/trains-order-payment';

import Text from 'components/Text/Text';

import cx from './ConfirmationTimer.scss';

interface IConfirmationTimerSkeletonProps
    extends IWithDeviceType,
        IWithClassName {}

const ConfirmationTimerSkeleton: React.FC<IConfirmationTimerSkeletonProps> = ({
    className,
    deviceType,
}) => (
    <div className={cx('root', className, deviceMods('root', deviceType))}>
        <Text
            className={cx('countdown')}
            weight="bold"
            size="m"
            color="primary"
        >
            --:--
        </Text>

        <Text size="m" color="primary">
            {i18nBlock.paymentDashTimerDashDescription()}
        </Text>
    </div>
);

export default ConfirmationTimerSkeleton;
