import {FC, memo} from 'react';
import {useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';

import partnersSelectors from 'projects/trains/components/TrainsOrderPage/PartnersRequisites/selectors/partnersSelectors';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import CommonPartnersRequisites from 'components/PartnersRequisites/PartnersRequisites';

interface IPartnersRequisitesProps extends IWithClassName, IWithQaAttributes {}

const PartnersRequisites: FC<IPartnersRequisitesProps> = props => {
    const {className} = props;

    const partners = useSelector(partnersSelectors);

    return (
        <CommonPartnersRequisites
            className={className}
            partners={partners}
            {...prepareQaAttributes(props)}
        />
    );
};

export default memo(PartnersRequisites);
